(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     13542,        357]
NotebookOptionsPosition[     13155,        343]
NotebookOutlinePosition[     13491,        358]
CellTagsIndexPosition[     13448,        355]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"files", "=", 
    RowBox[{"FileNames", "[", "\"\<./pars*\>\"", "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Generate", " ", "population", " ", "average", " ", "of", " ", "speed"}], 
    ",", " ", 
    RowBox[{"aspect", " ", "ratio", " ", "and", " ", "persistence"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"finalresult", "=", 
    RowBox[{"First", "@", 
     RowBox[{"Last", "@", 
      RowBox[{"Reap", "@", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tardirs", "=", 
           RowBox[{"FileNames", "@", 
            RowBox[{"(", 
             RowBox[{"file", "<>", "\"\</rng*\>\""}], ")"}]}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"msd", "=", 
           RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"result", "=", "\[IndentingNewLine]", 
           RowBox[{"Mean", "@", 
            RowBox[{"First", "@", 
             RowBox[{"Last", "@", 
              RowBox[{"Reap", "@", 
               RowBox[{"Do", "[", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Sow", "@", 
                   RowBox[{"Flatten", "@", 
                    RowBox[{"First", "@", 
                    RowBox[{"Last", "@", 
                    RowBox[{"Reap", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"config", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{"tardir", "<>", "\"\</config.json\>\""}], "]"}]}],
                     ";", "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"\"\<SUBSTRATE_ADHESION_POLARIZABILITY\>\"", "/.", 
                    RowBox[{"(", 
                    RowBox[{"\"\<CELL\>\"", "/.", "config"}], ")"}]}], "]"}], 
                    "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"\"\<STIFFNESS_MEMBRANE\>\"", "/.", 
                    RowBox[{"(", 
                    RowBox[{"\"\<CELL\>\"", "/.", "config"}], ")"}]}], "]"}], 
                    "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    
                    RowBox[{"tmp", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{
                    RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                    "\"\</Averages/Speed\>\""}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"\"\<Mean\>\"", "/.", "tmp"}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"tmp", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{
                    RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                    "\"\</Averages/AspectRatio\>\""}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"\"\<Mean\>\"", "/.", "tmp"}], "]"}], ";"}], 
                    "\[IndentingNewLine]", "]"}]}]}]}]}], ";", 
                  "\[IndentingNewLine]", 
                  RowBox[{"msd", "=", 
                   RowBox[{"Join", "[", 
                    RowBox[{"msd", ",", 
                    RowBox[{"Import", "[", 
                    RowBox[{
                    RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                    "\"\</Simple/MSD\>\""}], "]"}]}], "]"}]}], ";"}], 
                 "\[IndentingNewLine]", ",", 
                 RowBox[{"{", 
                  RowBox[{"tardir", ",", "tardirs"}], "}"}]}], 
                "]"}]}]}]}]}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"grpmsd", "=", 
           RowBox[{"GroupBy", "[", 
            RowBox[{"msd", ",", "First"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"meanmsd", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"\"\<DeltaTime\>\"", "/.", "val"}], "//", "Mean"}], 
               ",", 
               RowBox[{
                RowBox[{"\"\<Mean\>\"", "/.", "val"}], "//", "Mean"}], ",", 
               RowBox[{
                RowBox[{"\"\<Mean\>\"", "/.", "val"}], "//", 
                "StandardDeviation"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"val", ",", "grpmsd"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Fit", " ", "persistent", " ", "random", " ", "walk", " ", 
            "model"}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"msdfit", "=", 
           RowBox[{"NonlinearModelFit", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"meanmsd", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"2", ";;", 
                 RowBox[{"-", "1"}]}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], 
             "\[IndentingNewLine]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"2", "*", 
                RowBox[{"A", "^", "2"}], "*", 
                RowBox[{"tau", "^", "2"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Exp", "[", 
                   RowBox[{
                    RowBox[{"-", "t"}], "/", "tau"}], "]"}], "+", 
                  RowBox[{"t", "/", "tau"}], "-", "1"}], ")"}]}], ",", 
               RowBox[{"tau", ">", "0.0001"}], ",", 
               RowBox[{"A", ">", "0"}]}], "}"}], "\[IndentingNewLine]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"A", ",", "10"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"tau", ",", "10000"}], "}"}]}], "}"}], 
             "\[IndentingNewLine]", ",", "t", ",", 
             RowBox[{"Weights", "\[Rule]", 
              RowBox[{"1", "/", 
               RowBox[{
                RowBox[{"meanmsd", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"2", ";;", 
                    RowBox[{"-", "1"}]}], ",", "3"}], "]"}], "]"}], "^", 
                "2"}]}]}], ",", 
             RowBox[{"Method", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"NMinimize", ",", 
                RowBox[{"Method", "\[Rule]", "\"\<NelderMead\>\""}]}], 
               "}"}]}], ",", 
             RowBox[{"ConfidenceLevel", "\[Rule]", "0.999"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"result", ",", 
            RowBox[{"tau", "/.", 
             RowBox[{"msdfit", "[", "\"\<BestFitParameters\>\"", "]"}]}]}], 
           "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"Sow", "@", "result"}], ";"}], "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"file", ",", "files"}], "}"}]}], "]"}]}]}]}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Round", " ", "membrane", " ", "stiffness"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"finalresult", "[", 
      RowBox[{"[", 
       RowBox[{"k", ",", "2"}], "]"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Round", "[", 
        RowBox[{"1000", "*", 
         RowBox[{"finalresult", "[", 
          RowBox[{"[", 
           RowBox[{"k", ",", "2"}], "]"}], "]"}]}], "]"}], "/", "1000"}], "//",
       "N"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", 
      RowBox[{"Length", "@", "finalresult"}]}], "}"}]}], "]"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Group", " ", "data", " ", "by", " ", "perimeter", " ", "stiffness"}], " ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#1", " ", "specific", " ", "polarizability"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#2", " ", "membrane", " ", "stiffness"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#3", " ", "speed"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#4", " ", "aspect", " ", "ratio"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#5", " ", "persistence"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalresult", "=", 
   RowBox[{"SortBy", "[", 
    RowBox[{"finalresult", ",", 
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result0054", "=", 
   RowBox[{"0.054", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result0054", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.054"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result0057", "=", 
   RowBox[{"0.057", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result0057", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.057"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result0060", "=", 
   RowBox[{"0.060", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result0060", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.060"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result0063", "=", 
   RowBox[{"0.063", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result0063", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.063"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result0066", "=", 
   RowBox[{"0.066", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result0066", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.066"}], ";"}]}], "Input",\

 CellChangeTimes->{{3.772681322469673*^9, 3.772681397897786*^9}, 
   3.772681438305854*^9, {3.772681560056467*^9, 3.772681562384734*^9}, {
   3.776500079559926*^9, 3.7765000860188627`*^9}, {3.776500392064732*^9, 
   3.7765004198333397`*^9}, {3.776500493044935*^9, 3.776500498379397*^9}, {
   3.776500607608672*^9, 3.776500612479477*^9}, {3.776500832050807*^9, 
   3.7765008768982973`*^9}, {3.776500963537364*^9, 3.776501038837268*^9}, {
   3.776501759241064*^9, 3.776501833422694*^9}, {3.7765106261424294`*^9, 
   3.7765106331609793`*^9}, {3.7765353472715807`*^9, 
   3.7765353486479177`*^9}},ExpressionUUID->"3c25cb67-b0c9-4ec9-854f-\
63c51f0784e9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<~/Downloads/thueroffpaper_single_Q.dat\>\"", ",", 
    RowBox[{"Join", "[", 
     RowBox[{
     "result0054", ",", "result0057", ",", "result0060", ",", "result0063", 
      ",", "result0066"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.740798527981938*^9, 3.740798603571829*^9}, {
  3.776502063237015*^9, 3.7765020704139853`*^9}, {3.7765099092295923`*^9, 
  3.7765099209742002`*^9}},ExpressionUUID->"ae53f5a1-9f52-4e93-9cdf-\
f3393780fde3"]
},
WindowSize->{808, 755},
WindowMargins->{{Automatic, 40}, {Automatic, 0}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 11980, 306, 1291, "Input",ExpressionUUID->"3c25cb67-b0c9-4ec9-854f-63c51f0784e9"],
Cell[12541, 328, 610, 13, 73, "Input",ExpressionUUID->"ae53f5a1-9f52-4e93-9cdf-f3393780fde3"]
}
]
*)

